VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "SalesOrderSimulate"
   ClientHeight    =   3075
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3975
   LinkTopic       =   "Form1"
   ScaleHeight     =   3075
   ScaleWidth      =   3975
   StartUpPosition =   3  'Windows-Standard
   Begin VB.Frame Frame2 
      Height          =   825
      Left            =   135
      TabIndex        =   8
      Top             =   2115
      Width           =   3615
      Begin VB.TextBox txtPreis 
         Height          =   285
         Left            =   2070
         TabIndex        =   9
         Top             =   315
         Width           =   1185
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "Nettopreis pro Stk."
         Height          =   195
         Left            =   180
         TabIndex        =   10
         Top             =   315
         Width           =   1320
      End
   End
   Begin VB.Frame Frame1 
      Height          =   1410
      Left            =   90
      TabIndex        =   1
      Top             =   135
      Width           =   3615
      Begin VB.TextBox txtMenge 
         Height          =   285
         Left            =   1575
         TabIndex        =   7
         Text            =   "1"
         Top             =   945
         Width           =   1635
      End
      Begin VB.TextBox txtMaterialNr 
         Height          =   285
         Left            =   1575
         TabIndex        =   5
         Text            =   "M-05"
         Top             =   630
         Width           =   1635
      End
      Begin VB.TextBox txtKundenNr 
         Height          =   285
         Left            =   1575
         TabIndex        =   3
         Text            =   "0000001172"
         Top             =   315
         Width           =   1635
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Menge"
         Height          =   195
         Left            =   135
         TabIndex        =   6
         Top             =   945
         Width           =   495
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "Materialnummer"
         Height          =   195
         Left            =   135
         TabIndex        =   4
         Top             =   630
         Width           =   1110
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Kundennummer"
         Height          =   195
         Left            =   135
         TabIndex        =   2
         Top             =   315
         Width           =   1110
      End
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Preisanfrage"
      Height          =   405
      Left            =   135
      TabIndex        =   0
      Top             =   1620
      Width           =   2415
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private Sub Command1_Click()
Dim x As Long
Dim ConString As String
Dim hRfc As Long
Dim ret As Long
Dim Error As RFC_ERROR_INFO_EX

' Anmeldung an einem Applikationenserver
ConString = "ASHOST=XXX " & _
    "SYSNR=11 " & _
    "CLIENT=800 " & _
    "USER=XXX " & _
    "PASSWD=XXX " & _
    "LANG=D"
    

' RFC-Verbindung ffnen
hRfc = RfcOpenEx(ConString, Error)

If hRfc = 0 Then
    ' im Fehlerfall die Fehlermeldung abfragen und ausgegebn
    MsgBox "Logon failed " & vbCrLf & _
        Error.MESSAGE
    Exit Sub
End If


' Gengend Speicher fr die Tabellen-Parameter-bergabe
' reservieren
Dim hSpace As Long
hSpace = RfcAllocParamSpace(1, 1, 3)


' Der einzige Input-Parameter ORDER_HEADER_IN ist die Monster-Struktur BAPISHEAD
Dim ParamName As String
Dim HeaderIn As BAPISDHEAD

InitHeaderInStruct HeaderIn

ParamName = "ORDER_HEADER_IN"
HeaderIn.DOC_TYPE = "TA"
HeaderIn.SALES_ORG = "1000"
HeaderIn.DISTR_CHAN = "10"
HeaderIn.DIVISION = "00"
HeaderIn.PURCH_NO = "4711" ' Dummy-Bestellnummer, damit keine Warnung kommt

ret = RfcAddExportStructure(hSpace, 0, ParamName, Len(ParamName), _
    RFC_CHAR, Len(HeaderIn), HeaderIn)
If ret <> RFC_OK Then
    MsgBox "Fehler in RfcAddExportParam 1": Exit Sub: End If
    
' Die erste Tabelle ORDER_ITEMS_IN mit der Struktur BAPIITEMIN
' enthlt die Positionen des Auftrags
Dim hIT1 As Long
Dim iLine As Long
Dim OrderItemIn As BAPIITEMIN

InitItemStruct OrderItemIn

hIT1 = ItCreate("BAPIITEMIN", Len(OrderItemIn), 0, 0)
If hIT1 = 0 Then MsgBox "Fehler bei ItCreate !!"

OrderItemIn.MATERIAL = txtMaterialNr.Text
OrderItemIn.REQ_QTY = txtMenge.Text & "000"
iLine = ItAppLine(hIT1)
CopyMemoryWrite iLine, OrderItemIn, Len(OrderItemIn)

ret = RfcAddTable(hSpace, 0, "ORDER_ITEMS_IN", Len("ORDER_ITEMS_IN"), 0, _
    Len(OrderItemIn), hIT1)
If ret <> RFC_OK Then
    MsgBox "Fehler in RfcAddTable 1": Exit Sub: End If

' Die zweite Tabelle der Partner mit Inhalten fllen
Dim hIT2 As Long
Dim iLine2 As Long
Dim Partners As BAPIPARTNR

InitPartnerStruct Partners

hIT2 = ItCreate("BAPIPARTNR", Len(Partners), 0, 0)
If hIT2 = 0 Then MsgBox "Fehler bei ItCreate 2 !!"

Partners.PARTN_ROLE = "AG"
Partners.PARTN_NUMB = txtKundenNr.Text
iLine2 = ItAppLine(hIT2)
CopyMemoryWrite iLine2, Partners, Len(Partners)

ret = RfcAddTable(hSpace, 1, "ORDER_PARTNERS", Len("ORDER_PARTNERS"), 0, Len(Partners), hIT2)
If ret <> RFC_OK Then
    MsgBox "Fehler in RfcAddTable 2": Exit Sub: End If

' Jetzt die Ausgangstabelle fr die Preisstrukturen anmelden
Dim Price As BAPICOND
Dim hIT3 As Long
hIT3 = ItCreate("BAPICOND", Len(Price), 0, 0)
ret = RfcAddTable(hSpace, 2, "ORDER_CONDITION_EX", Len("ORDER_CONDITION_EX"), 0, Len(Price), hIT3)
If ret <> RFC_OK Then
    MsgBox "Fehler in RfcAddTable 2": Exit Sub: End If


' Die Empfangsparameter definieren
Dim BapiRet As BAPIRETURN
ret = RfcDefineImportParam(hSpace, 0, "RETURN", Len("RETURN"), 0, Len(BapiRet))

' Jetzt erfolgt der eigentliche Aufruf
Dim Exception As String
Exception = Space(255) & vbNullChar

ret = RfcCallReceiveExt(hRfc, hSpace, "BAPI_SALESORDER_SIMULATE", Exception)

If ret <> RFC_OK Then
    MsgBox "Exception: " & Exception
    Exit Sub
End If

ret = RfcGetImportStructure(hSpace, 0, BapiRet)
If ret <> RFC_OK Then
    MsgBox "Fehler in RfcGetImportParam": Exit Sub: End If
    
If Trim(BapiRet.MESSAGE) <> "" Then
    MsgBox (BapiRet.MESSAGE)
    Exit Sub
End If


For x = 1 To ItFill(hIT3)
    iLine = ItGetLine(hIT3, x)
    If iLine > 0 Then
        CopyMemoryRead Price, iLine, Len(Price)
        If Price.COND_TYPE = "PR00" Then ' wir haben die Kondition fr den Nettopreis gefunden
            txtPreis.Text = ConvertBCDToDbl(Price.COND_VALUE, 9)
        End If
    End If
Next x

RfcClose hRfc

End Sub


